@echo off

setlocal

set local-user=administrator
set deployment-path=c:\craig\util\Lansweeper

:: Ensure that we're in the same directory as this file (Run as Administrator starts in c:\windows\system32).
cd /d %~dp0

:: Ensure that deployment path exists.
if not exist %deployment-path% md %deployment-path%

:: Ensure that deployment files exist.
copy /y *.* %deployment-path%

:: Ensure that the user exists and has the expected password.
net user %local-user%
if %errorlevel% neq 0 (
	echo %local-user% does not exist. Creating...
	:: * prompts for a password
	net user %local-user% * /add /expires:never /passwordchg:yes /passwordreq:yes /logonpasswordchg:no
) else (
	echo %local-user% found. Ensuring correct and password...
	net user %local-user% *
)

echo Ensuring %local-user% has correct group membership...
net localgroup "Administrators" %local-user% /add 2> nul

echo Adding scheduled task
schtasks /create /xml "Lansweeper Push Scheduled Task.xml" /tn "\User\Lansweeper Push" /ru "Administrator"